﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PI.ZB.N1200.ELearning.WebApplication.Accounts;

namespace PI.ZB.N1200.ELearning.WebApplication.Statistics
{
    public abstract partial class StatsBaseComponent : BaseComponent
    {
        /// <summary>
        /// Rodzaje paneli statystyki studenta i instruktora
        /// </summary>
        public enum AreaType
        {
            /// <summary>
            /// Nie zostal odczytany
            /// </summary>
            NotLoaded = -1,
            /// <summary>
            /// Brak panelu
            /// </summary>
            None = 0,

            /// <summary>
            /// Podsumowanie nauki dla studenta, wyniki z kompetencji głównych
            /// </summary>
            StudentCompetencePanel = 1,

            /// <summary>
            /// Szczegóły kompetencji głównej w widku dla studenta
            /// </summary>
            StudentCompetencePartPanel = 2,

            StudentRanking1Panel = 3,
            StudentRanking2Panel = 4,
            StudentRanking3Panel = 5,

            /// <summary>
            /// Lista klas z podsumowaniem
            /// </summary>
            InstructorClassListPanel = 10,

            /// <summary>
            /// Szczegóły klasy - pojedyncza klasa i jej kompetencje gówne
            /// </summary>
            InstructorClassCompetencePanel = 11,

            /// <summary>
            /// Szczegóły kompetencji składowej dla danej klasy
            /// </summary>
            InstructorClassCompetencePartPanel = 12,

            /// <summary>
            /// Lista studentów z podsumowaniami w widoku dla instruktora
            /// </summary>
            InstructorStudentListPanel = 13,

            /// <summary>
            /// Widok szczegółowy studenta z listą kompetencji głównych w widoku dla instruktora
            /// </summary>
            InstructorStudentCompetencePanel = 14,

            /// <summary>
            /// Widok szczegółowy dla kompetencji głównej - czyli wszystkie kompetencje składowe w kontekście studenta w widoku dla instruktora
            /// </summary>
            InstructorStudentCompetencePartPanel = 15,

            InstructorRanking1Panel = 16,
            InstructorRanking2Panel = 17,
            InstructorRanking3Panel = 18,
        }

        /// <summary>
        /// panele adminsitracyjne na poszczegolne rodzaje aktywnosci
        /// </summary>
        private Dictionary<AreaType, StatsPanel> _statsPanelDictionary = new Dictionary<AreaType, StatsPanel>();


        public StatsBaseComponent(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam)
            : base(WebPageComponentParam)
        {
        }

        protected void Register(AreaType Area, StatsPanel Panel)
        {
            _statsPanelDictionary.Add(Area, Panel);
        }

        public new Gemini.Core.WebApplication.Base.GXML XML { get { return base.XML; } }

        private AreaType _area = AreaType.NotLoaded;
        protected AreaType Area
        {
            get
            {
                if (_area == AreaType.NotLoaded)
                {
                    _area = AreaType.None;
                    string _areaString = Environment.GetRequestParamString("area");
                    if (!string.IsNullOrEmpty(_areaString))
                    {
                        try
                        {
                            _area = (AreaType)Enum.Parse(typeof(AreaType), _areaString, true);
                        }
                        catch { }
                    }
                }
                return _area;
            }
            set
            {
                _area = value;
            }
        }

        private BL.BO.Instructor _instructor = null;
        public BL.BO.Instructor Instructor
        {
            get
            {
                if (_instructor == null)
                {
                    _instructor = BLELearning.Instructor.RestoreByUser(Environment.User);
                }
                return _instructor;
            }
        }


        private BL.BO.Student _student = null;
        public BL.BO.Student Student
        {
            get
            {
                if (_student == null)
                {
                    _student = BLELearning.Student.RestoreByUser(Environment.User);
                }
                return _student;
            }
        }
        
        public override bool Save()
        {
            if (WebPageEngine.IsUserAuthorized)
            {
                if (_statsPanelDictionary.ContainsKey(Area))
                {
                    _statsPanelDictionary[Area].Save();
                }
            }
            return true;
        }

        public override void Load()
        {
            #region Config
            XML.Element.Start("Config");
            XML.Element.Attribute("IUA", WebPageEngine.IsUserAuthorized ? "1" : "0");
            XML.Element.Attribute("AreaValue", Area.ToString());
            XML.Element.Attribute("Area", (int)Area);
            if (Environment.User != null)
            {
                XML.Element.Attribute("UserID", Environment.User.ID);
            }
            if (Environment.SessionManager != null && Environment.SessionManager.Current != null)
            {
                XML.Element.Attribute("SessionUID", Environment.SessionManager.Current.UID);
            }            
            XML.Element.End();
            #endregion

            if (WebPageEngine.IsUserAuthorized)
            {
                if (_statsPanelDictionary.ContainsKey(Area))
                {
                    _statsPanelDictionary[Area].Load();
                }
            }
        }
    }
}